/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.data;

import com.andavin.images.data.DataManager;
import com.andavin.images.image.CustomImage;
import com.andavin.reflect.exception.UncheckedClassNotFoundException;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public class FileDataManager
implements DataManager {
    private final File dataFile;

    public FileDataManager(File dataFile) {
        Preconditions.checkArgument((!dataFile.exists() || dataFile.isFile() ? 1 : 0) != 0, (String)"not a file %s", (Object[])new Object[]{dataFile});
        this.dataFile = dataFile;
    }

    @Override
    public void initialize() {
    }

    @Override
    public synchronized List<CustomImage> load() {
        ArrayList<CustomImage> images;
        byte[] data;
        if (!this.dataFile.exists()) {
            return new ArrayList<CustomImage>();
        }
        try {
            data = Files.readAllBytes(this.dataFile.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (data.length == 0) {
            return new ArrayList<CustomImage>();
        }
        try (ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(data));){
            int capacity = stream.readInt();
            images = new ArrayList<CustomImage>(capacity);
            for (int i = 0; i < capacity; ++i) {
                images.add((CustomImage)stream.readObject());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedClassNotFoundException(e.getMessage(), e);
        }
        return images;
    }

    @Override
    public void save(CustomImage image) {
        List<CustomImage> images = this.load();
        images.add(image);
        this.saveAll(images);
    }

    @Override
    public synchronized void saveAll(List<CustomImage> images) {
        if (images.isEmpty()) {
            return;
        }
        File dataFile = new File(this.dataFile.getAbsolutePath() + ".tmp");
        try (ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(dataFile));){
            stream.writeInt(images.size());
            for (CustomImage image : images) {
                stream.writeObject(image);
            }
            Files.move(dataFile.toPath(), this.dataFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void delete(CustomImage image) {
        List<CustomImage> images = this.load();
        if (images.remove(image)) {
            this.saveAll(images);
        }
    }
}

